<?php

namespace Beedask\Models;

use Illuminate\Database\Eloquent\Model;

class Activity extends Model 
{

    protected $table = 'activities';
    public $timestamps = true;
    protected $fillable = array('user_id', 'subject_id', 'subject_type', 'type');
    protected $visible = array('user_id', 'subject_id', 'subject_type', 'type');

    public function subject()
    {
        return $this->morphTo();
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}